/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Sets;
import cz.insophy.inplan.planning.mokos.CumulativePipelineStub;
import cz.insophy.inplan.planning.mokos.GroupPipelineStub;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.OperationGroup;
import cz.insophy.inplan.planning.mokos.Processor;
import cz.insophy.inplan.planning.mokos.SinglePipelineStub;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.CumulativeAction;
import cz.insophy.inplan.util.Tuple;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationTypeSwitch
extends Processor {
    private static final Logger log = LoggerFactory.getLogger(OperationTypeSwitch.class);
    private Processor singleProc;
    private Processor cumulProc;
    private Processor groupProc;
    private Set<Operation> planneableOps = Sets.newHashSet();
    private Set<Operation> planneableOpsView = Collections.unmodifiableSet(this.planneableOps);

    @Override
    public void setSuccessors(List<Processor> successors) {
        super.setSuccessors(successors);
        Preconditions.checkArgument(successors.size() == 2 || successors.size() == 3);
        for (Processor proc : successors) {
            if (proc.getClass() == PipelineTypeStubs.SINLGE.getStubClass()) {
                this.singleProc = proc;
                continue;
            }
            if (proc.getClass() == PipelineTypeStubs.CUMULATIVE.getStubClass()) {
                this.cumulProc = proc;
                continue;
            }
            if (proc.getClass() == PipelineTypeStubs.GROUP.getStubClass()) {
                this.groupProc = proc;
                continue;
            }
            throw new IllegalStateException("OperationTypeSwitch must be followed by at least two processors from " + Arrays.asList(PipelineTypeStubs.values()));
        }
        Preconditions.checkNotNull(this.singleProc, "Single processor pipeline must be defined.");
        Preconditions.checkNotNull(this.cumulProc, "Cumulative processor pipeline must be defined.");
    }

    @Override
    public Tuple<Processor, Set<Operation>> process(Set<Operation> ops) {
        Processor selectedSuccessor;
        this.planneableOps.clear();
        ArrayListMultimap<OperationGroup, Operation> releasedGroups = ArrayListMultimap.create();
        for (Operation operation : ops) {
            Action action = operation.getAction();
            if (action instanceof CumulativeAction) {
                Preconditions.checkState(!operation.isGrouped(), "Cumulative operation (%s) cannot be part of a group.", (Object)operation);
                this.planneableOps.add(operation);
                continue;
            }
            if (!operation.isGrouped()) continue;
            releasedGroups.put(operation.getGroup(), operation);
        }
        Preconditions.checkState(releasedGroups.size() == 0 || this.groupProc != null, "There are some operation groups but group pipeline is not configured.");
        if (!this.planneableOps.isEmpty()) {
            selectedSuccessor = this.cumulProc;
        } else {
            for (Map.Entry entry : releasedGroups.asMap().entrySet()) {
                int releasedCount;
                int groupSize = ((OperationGroup)entry.getKey()).size();
                if (groupSize != (releasedCount = ((Collection)entry.getValue()).size())) continue;
                this.planneableOps.addAll((Collection)entry.getValue());
            }
            if (!this.planneableOps.isEmpty()) {
                selectedSuccessor = this.groupProc;
            } else {
                selectedSuccessor = this.singleProc;
                for (Operation operation : ops) {
                    if (operation.isGrouped()) continue;
                    this.planneableOps.add(operation);
                }
                if (this.planneableOps.isEmpty()) {
                    log.warn("Trying to recover from the state when only part of the group is planned.");
                    for (OperationGroup operationGroup : releasedGroups.keySet()) {
                        long groupBound = operationGroup.iterator().next().getBound().getTime();
                        operationGroup.updateBound(this, groupBound + 86400000L);
                    }
                }
            }
        }
        return Tuple.create(selectedSuccessor, this.planneableOpsView);
    }

    public static enum PipelineTypeStubs {
        CUMULATIVE(CumulativePipelineStub.class),
        SINLGE(SinglePipelineStub.class),
        GROUP(GroupPipelineStub.class);

        private final Class<? extends Processor> stubClass;

        public Class<? extends Processor> getStubClass() {
            return this.stubClass;
        }

        private PipelineTypeStubs(Class<? extends Processor> stubClass) {
            this.stubClass = stubClass;
        }
    }
}

